package gov.va.med.mhv.common.data.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "ACCESS_ROLE")
public class AccessRole extends AbstractBaseEntity {

	private static final long serialVersionUID = 823488229562277991L;

	@Id
	@Column(name = "ACCESS_ROLE_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "NAME")
	private String name;

	@Column(name = "IS_DEFAULT_PATIENT_ROLE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isDefaultPatientRole;

	@Column(name = "IS_DEFAULT_USER_ROLE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean isDefaultUserRole;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Boolean getIsDefaultPatientRole() {
		return isDefaultPatientRole;
	}

	public void setIsDefaultPatientRole(Boolean isDefaultPatientRole) {
		this.isDefaultPatientRole = isDefaultPatientRole;
	}

	public Boolean getIsDefaultUserRole() {
		return isDefaultUserRole;
	}

	public void setIsDefaultUserRole(Boolean isDefaultUserRole) {
		this.isDefaultUserRole = isDefaultUserRole;
	}
}
